//package globalExamples;

import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.StringSource;

import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

/**
 * Complete code for Example 7-14, Using the Lag Method, in 
 * Chapter 7, Making Queries Using Source Methods, in the 
 * Oracle OLAP Developer's Guide to the  OLAP API.
 * 
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 * 
 * @author Oracle Corporation
 */
public class UsingLagMethod 
{
  public UsingLagMethod()
  {
  }

  public void run(String[] args) 
  {
    Context10g context = new Context10g(args, false);
    DataProvider dp = context.getDataProvider();

    context.println("Example 7-14, Using the Lag Method");
    
    MdmPrimaryDimension[] mdmPrimDims = 
         context.getMdmPrimaryDimensionsByName(new String[]
                                               {"PRODUCT", 
                                                "TIME"});

    MdmMeasure mdmUnitPrice = context.getMdmMeasureByName("UNIT_PRICE");
    NumberSource unitPrice = (NumberSource) mdmUnitPrice.getSource();

    MdmPrimaryDimension mdmProdDim = mdmPrimDims[0];
    //StringSource prodDim = (StringSource) mdmProdDim.getSource();
    MdmLevelHierarchy mdmProdHier = (MdmLevelHierarchy)
                                           mdmProdDim.getDefaultHierarchy();
    StringSource prodHier = (StringSource) mdmProdHier.getSource();
    Source prodSel = prodHier.selectValue("PRODUCT_ROLLUP::FAMILY::5");

    MdmPrimaryDimension mdmTimeDim = mdmPrimDims[1];
    MdmLevelHierarchy mdmTimeHier = (MdmLevelHierarchy)
                                           mdmTimeDim.getDefaultHierarchy();
    StringSource timeHier = (StringSource) mdmTimeHier.getSource();

    MdmLevel mdmQuarterLevel = context.getLevelByName(mdmTimeHier, 
                                                      "QUARTER");
    Source quarterLevel = mdmQuarterLevel.getSource();

    NumberSource unitPriceLag4 = unitPrice.lag(mdmTimeHier, 4);
    Source measuresDim = dp.createListSource(new Source[] {unitPrice, 
                                                           unitPriceLag4});

    Source lagResult = measuresDim.extract()
                                  .join(measuresDim)
                                  .join(quarterLevel)
                                  .joinHidden(prodSel);     
    
    context.commit();
    context.displayResult(lagResult);
    
  }

  public static void main(String[] args)
  {
    new UsingLagMethod().run(args);
  }
}
